﻿<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Informacja miesięczna INF-1</title>
		<script runat="server">

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }
        
        bool schorzenia = true;
        [Caption("Słownik schorzeń")]
        public bool Schorzenia {
            get { return schorzenia; }
            set {
                schorzenia = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        bool zaznaczeni = false;
        [Caption("Pracownicy wg listy")]
        public bool Zaznaczeni {
            get { return zaznaczeni; }
            set {
                zaznaczeni = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
  
	public class PrnParams: Soneta.Business.ContextBase {
		public PrnParams(Context context) : base(context) {
			Date data = Date.Empty;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			if (data == Date.Empty)
				data = Date.Today;
			miesiąc = new YearMonth(data);
		}
		
		YearMonth miesiąc;
		[Required]
		[Caption("Raport za")]
		public YearMonth Miesiąc {
			get { return miesiąc; }
			set { 
				miesiąc = value; 
				OnChanged(EventArgs.Empty);
			}
		}
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		set { pars = value; } 
	}

    Dictionary<OddzialFirmy, List<Pracownik>> dict = new Dictionary<OddzialFirmy, List<Pracownik>>();
    List<OddzialFirmy> oddzialy = new List<OddzialFirmy>();
    string title;
    ZPCHR zpchr;
    
    void OnContextLoad(Object sender, EventArgs args) {
		ReportHeader1["MIESIĄC"] = pars.Miesiąc.ToString();
        if (srpars.Zaznaczeni)
            ReportHeader1["FILTR"] = "Wydruk dla odfiltrowanych pracowników";
        else
            ReportHeader1["FILTR"] = "";
        title = ReportHeader1.Title;

        KadryModule kadry = KadryModule.GetInstance(dc);
        IEnumerable rows;
        if (srpars.Zaznaczeni)
            rows = (Pracownik[])dc[typeof(Pracownik[])];
        else
            rows = kadry.Pracownicy.GetNaEtatach(pars.Miesiąc.ToFromTo());

        List<Pracownik> list;
        if (Soneta.Core.Tools.WieloodzialowoscPlatynowa(dc.Session)) {
            Date data = pars.Miesiąc.FirstDay;
            foreach (Pracownik pracownik in rows) {
                PracHistoria ph = pracownik[data];
                OddzialFirmy of = ph.Etat.Wydzial != null ? ph.Etat.Wydzial.Oddzial : null;
                while (of != null) {
			        if (of.GetObjectRight() != AccessRights.Denied &&
                        of.Deklaracje.PFRON == NaliczanieDeklaracjiOddziału.Naliczaj)
                        break;
                    of = of.Nadrzedny;
                }
                if (of == null)
                    continue;
                if (!dict.TryGetValue(of, out list))
                    dict.Add(of, list = new List<Pracownik>());
                list.Add(pracownik);
            }
        }
        else {
            dict.Add(new OddzialFirmy(RowCreator.Empty), list = new List<Pracownik>());
            foreach (Pracownik pracownik in rows)
                list.Add(pracownik);
        }

        zpchr = new ZPCHR(true, pars.Miesiąc, ZPCHR.WarunkiNaliczania.PFRON);
        ArrayList lista = new ArrayList();
        oddzialy.AddRange(dict.Keys);
        foreach (OddzialFirmy of in oddzialy)
            lista.Add(zpchr.Razem(dict[of]));
        DataRepeater1.DataSource = lista;
    }
	
	void OnBeforeRow(Object sender, EventArgs args) {
        OddzialFirmy of = oddzialy[0];
        oddzialy.Remove(of);
        ReportHeader1.Title = !string.IsNullOrEmpty(of.Symbol) ? title.Replace("%ODDZIAL%", "Oddział: " + of) : title.Replace("%ODDZIAL%", "");

        ZPCHR.MiesiącInfo inf = (ZPCHR.MiesiącInfo)DataRepeater1.CurrentRow;
        EtatyNiepełnosprawni.EditValue = inf.EtatyNiepełnosprawni + inf.EtatyNiepełnosprawniDo16roku + inf.EtatyNiepełnosprawniBezSTN;
        Niepełnosprawni.EditValue = inf.Niepełnosprawni + inf.NiepełnosprawniDo16roku + inf.NiepełnosprawniBezSTN;

        decimal znaczny1O = 0, umiarkowany1O = 0, lekki1O = 0, bez1O = 0;
        decimal znaczny1E = 0, umiarkowany1E = 0, lekki1E = 0, bez1E = 0;
        decimal znaczny2O = 0, umiarkowany2O = 0, lekki2O = 0, bez2O = 0;
        decimal znaczny2E = 0, umiarkowany2E = 0, lekki2E = 0, bez2E = 0;
        decimal znaczny3O = 0, umiarkowany3O = 0;
        decimal znaczny3E = 0, umiarkowany3E = 0;

        int days = pars.Miesiąc.Days;        
        Set<Pracownik> pracownicy = new Set<Pracownik>();
        foreach (Pracownik p in dict[of]) {
            Pracownik pracownik = p.EtatGłówny;
            if (pracownicy.Contains(pracownik))
                continue;
            pracownicy.Add(pracownik);
            IEnumerable it = zpchr[pracownik];
            Periods okresOsoby = Periods.Empty;
            foreach (ZPCHR.OkresInfo info in it) {
                if (!info.Wchodzi)
                    continue;

                PracHistoria ph = pracownik[info.Okres.From];
                int osoby = (Periods.New(info.Okres) - okresOsoby).Days;
                decimal etaty = (decimal)info.Wymiar * info.Okres.Days;
                okresOsoby += info.Okres;
                
                bool choroba = false;
                bool upośledzenie = false;
                bool niewidomy = false;
                bool epilepsja = false;
                bool calosciowe = false;
                bool niedotyczy = false;
                bool chalupnik = ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Chałupnik;

                if (srpars.Schorzenia)
                    switch (ph.PFRON.TypSchorzeniaSOD) {
                        case SzczególneSchorzeniaSOD.ChorobyPsychiczne:
                            choroba = true;
                            break;
                        case SzczególneSchorzeniaSOD.UpośledzeniaUmysłowe:
                            upośledzenie = true;
                            break;
                        case SzczególneSchorzeniaSOD.ChorobyNarząduWzroku:
                            niewidomy = true;
                            break;
                        case SzczególneSchorzeniaSOD.Epilepsja:
                            epilepsja = true;
                            break;
                        case SzczególneSchorzeniaSOD.CałościoweZaburzeniaRozwojowe:
                            calosciowe = true;
                            break;
                    }
                else                  
                    switch (info.TypSchorzenia) {
                        case SzczegolneSchorzenia.ChorobaPsychiczna:
                            choroba = true;
                            break;
                        case SzczegolneSchorzenia.UpośledzenieUmysłowe:
                            upośledzenie = true;
                            break;
                        case SzczegolneSchorzenia.Niewidomy:
                            niewidomy = true;
                            break;
                        case SzczegolneSchorzenia.Epilepsja:
                            epilepsja = true;
                            break;
                        case SzczegolneSchorzenia.NieDotyczy:
                            niedotyczy = true;
                            break;   
                    }

                if (info.BezSTN || info.Do16roku) {
                    if (chalupnik) {
                        bez1O += osoby;
                        bez1E += etaty;
                    }
                    if (choroba || upośledzenie || niewidomy) {
                        bez2O += osoby;
                        bez2E += etaty;
                    }
                }
                else switch (info.STN) {
                    case StNiepełnosprawności.Brak:
                        continue;
                    case StNiepełnosprawności.Lekki:
                        if (chalupnik) {
                            lekki1O += osoby;
                            lekki1E += etaty;
                        }
                        if (choroba) {
                            lekki2O += osoby;
                            lekki2E += etaty;
                        }
                        break;
                    case StNiepełnosprawności.Umiarkowany:
                        if (chalupnik) {
                            umiarkowany1O += osoby;
                            umiarkowany1E += etaty;
                        }
                        if (choroba || upośledzenie || niewidomy) {
                            umiarkowany2O += osoby;
                            umiarkowany2E += etaty;
                        }
                        if (choroba || upośledzenie || niewidomy || epilepsja || calosciowe) {
                            umiarkowany3O += osoby;
                            umiarkowany3E += etaty;
                        }
                        break;
                    case StNiepełnosprawności.Znaczny:
                        if (chalupnik) {
                            znaczny1O += osoby;
                            znaczny1E += etaty;
                        }
                        if (choroba || upośledzenie || niewidomy) {
                            znaczny2O += osoby;
                            znaczny2E += etaty;
                        }
                        znaczny3O += osoby;
                        znaczny3E += etaty;
                        break;
                }
            }
        }
        
        if (days != 0) {
            znaczny1O /= days; umiarkowany1O /= days; lekki1O /= days; bez1O /= days;
            znaczny1E /= days; umiarkowany1E /= days; lekki1E /= days; bez1E /= days;
            znaczny2O /= days; umiarkowany2O /= days; lekki2O /= days; bez2O /= days;
            znaczny2E /= days; umiarkowany2E /= days; lekki2E /= days; bez2E /= days;
            znaczny3O /= days; umiarkowany3O /= days;
            znaczny3E /= days; umiarkowany3E /= days;
        }
        
        EtatyChalupnicyZnaczny.EditValue = znaczny1E;
        EtatyChalupnicyUmiarkowany.EditValue = umiarkowany1E;
        EtatyChalupnicyLekki.EditValue = lekki1E;
        EtatyChalupnicyBez.EditValue = bez1E;
        OsobyChalupnicyZnaczny.EditValue = znaczny1O;
        OsobyChalupnicyUmiarkowany.EditValue = umiarkowany1O;
        OsobyChalupnicyLekki.EditValue = lekki1O;
        OsobyChalupnicyBez.EditValue = bez1O;

        EtatyWybraniZnaczny.EditValue = znaczny2E;
        EtatyWybraniUmiarkowany.EditValue = umiarkowany2E;
        EtatyWybraniLekki.EditValue = lekki2E;
        EtatyWybraniBez.EditValue = bez2E;
        OsobyWybraniZnaczny.EditValue = znaczny2O;
        OsobyWybraniUmiarkowany.EditValue = umiarkowany2O;
        OsobyWybraniLekki.EditValue = lekki2O;
        OsobyWybraniBez.EditValue = bez2O;

        EtatyWskazaniZnaczny.EditValue = znaczny3E;
        EtatyWskazaniUmiarkowany.EditValue = umiarkowany3E;
        OsobyWskazaniZnaczny.EditValue = znaczny3O;
        OsobyWskazaniUmiarkowany.EditValue = umiarkowany3O;

        EtatyWszyscyZnaczny.EditValue = inf.EtatyZnacznySchorzenia;
        EtatyWszyscyUmiarkowany.EditValue = inf.EtatyUmiarkowanySchorzenia;
        OsobyWszyscyZnaczny.EditValue = inf.ZnacznySchorzenia;
        OsobyWszyscyUmiarkowany.EditValue = inf.UmiarkowanySchorzenia;    
    }
    
	static void Msg(object obj) {
	}
	
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="InformacjaMiesięcznaINF1" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:DataRepeater id="DataRepeater1" runat="server" Width="100%" RowTypeName="Soneta.Kadry.ZPCHR+MiesiącInfo,Soneta.KadryPlace"
                onbeforerow="OnBeforeRow">
                <ea:PageBreak ID="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="True"></ea:PageBreak>
				<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="INFORMACJA DLA DEKLARACJI DEK-II-a|</strong>Raport za: <strong>%MIESIĄC%|%FILTR%|%ODDZIAL%"
					runat="server"></cc1:reportheader>
				<DIV style="FONT-WEIGHT: bold; FONT-SIZE: 8pt; WIDTH: 100%; BORDER-BOTTOM: thin solid; FONT-FAMILY: Verdana">
                    D. Dane o zatrudnieniu
                </DIV>
				<P>
					<TABLE id="Table3" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="5%">E</TD>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="20%">Zatrudnienie ogółem</TD>
							<TD align="left" width="20%">
								<TABLE id="Table6" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">27.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel1" runat="server" Format="{0:n}" DataMember="Etaty"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD align="center" width="35%">w tym osób niepełnosprawnych ogółem</TD>
							<TD align="right">
								<TABLE id="Table7" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">28.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="EtatyNiepełnosprawni"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
						<TR>
							<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" align="center" width="5%">O</TD>
							<TD align="center" width="20%">Zatrudnienie ogółem</TD>
							<TD width="20%">
								<TABLE id="Table15" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">29.</TD>
										<TD align="right">
											<ea:DataLabel id="DataLabel10" runat="server" Format="{0:n}" DataMember="Pracownicy"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD align="center" width="35%">w tym osób niepełnosprawnych ogółem</TD>
							<TD>
								<TABLE id="Table14" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">30.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" id="Niepełnosprawni"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">Wykonawcy pracy nakładczej, o których mowa w art. 28 ust. 3 ustawy:<BR>
					<TABLE id="Table2" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="24%">
								<P align="center">znacznym</P>
							</TD>
							<TD width="24%">
								<P align="center">umiarkowanym</P>
							</TD>
							<TD width="24%">
								<P align="center">lekkim</P>
							</TD>
							<TD width="25%">
								<P align="center">bez ustalonego stopnia niepełnosprawności</P>
							</TD>
						</TR>
						<TR>
							<TD width="5%" align="center">E</TD>
							<TD>
								<TABLE id="Table13" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">31.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyChalupnicyZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table21" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">32.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyChalupnicyUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table22" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">33.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyChalupnicyLekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table23" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">34.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyChalupnicyBez"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
                        </TR>
						<TR>
							<TD width="5%" align="center">O</TD>
							<TD>
								<TABLE id="Table26" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">35.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyChalupnicyZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table27" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">36.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyChalupnicyUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table28" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">37.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyChalupnicyLekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table29" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">38.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyChalupnicyBez"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">Osoby, o których mowa w art. 28 ust. 1 pkt 1 lit. b ustawy:<BR>
					<TABLE id="Table24" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="24%">
								<P align="center">znacznym</P>
							</TD>
							<TD width="24%">
								<P align="center">umiarkowanym</P>
							</TD>
							<TD width="24%">
								<P align="center">lekkim</P>
							</TD>
							<TD width="25%">
								<P align="center">bez ustalonego stopnia niepełnosprawności</P>
							</TD>
						</TR>
						<TR>
							<TD width="5%" align="center">E</TD>
							<TD>
								<TABLE id="Table25" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">39.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWybraniZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table30" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">40.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWybraniUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table31" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">41.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWybraniLekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table32" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">42.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWybraniBez"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
                        </TR>
						<TR>
							<TD width="5%" align="center">O</TD>
							<TD>
								<TABLE id="Table33" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">43.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWybraniZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table34" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">44.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWybraniUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table35" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">45.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWybraniLekki"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table36" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">46.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWybraniBez"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
						</TR>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">Osoby, o których mowa w art. 22 ust. 1 ustawy:<BR>
					<TABLE id="Table37" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="24%">
								<P align="center">znacznym</P>
							</TD>
							<TD width="24%">
								<P align="center">umiarkowanym</P>
							</TD>
							<TD width="49%"></TD>
						</TR>
						<TR>
							<TD width="5%" align="center">E</TD>
							<TD>
								<TABLE id="Table38" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">47.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWskazaniZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table39" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">48.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWskazaniUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD></TD>
                        </TR>
						<TR>
							<TD width="5%" align="center">O</TD>
							<TD>
								<TABLE id="Table42" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">49.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWskazaniZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table43" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">50.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWskazaniUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD></TD>
						</TR>
					</TABLE>
				</P>
				<P style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">Osoby, o których mowa w art. 21 ust. 4 ustawy:<BR>
					<TABLE id="Table1" style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana" cellSpacing="0" cellPadding="0"
						width="100%" border="1">
						<TR>
							<TD width="5%">&nbsp;</TD>
							<TD width="24%">
								<P align="center">znacznym</P>
							</TD>
							<TD width="24%">
								<P align="center">umiarkowanym</P>
							</TD>
							<TD width="49%"></TD>
						</TR>
						<TR>
							<TD width="5%" align="center">E</TD>
							<TD>
								<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">51.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWszyscyZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table5" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">52.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="EtatyWszyscyUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD></TD>
                        </TR>
						<TR>
							<TD width="5%" align="center">O</TD>
							<TD>
								<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">53.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWszyscyZnaczny"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD>
								<TABLE id="Table9" cellSpacing="0" cellPadding="0" width="100%" border="0">
									<TR>
										<TD style="FONT-SIZE: 8pt; FONT-FAMILY: Verdana">54.</TD>
										<TD align="right">
											<ea:DataLabel runat="server" Format="{0:n}" ID="OsobyWszyscyUmiarkowany"></ea:DataLabel></TD>
									</TR>
								</TABLE>
							</TD>
							<TD></TD>
						</TR>
					</TABLE>
				</P>
			    <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
			</ea:DataRepeater>
		</form>
	</body>
</HTML>
